<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;
    protected $fillable = array('parent_id');

    public function blogs()
    {
        return $this->hasMany('Blog', 'category_id');
    }

    public function projects()
    {
        return $this->hasMany('Project', 'category_id');
    }

    public function questions()
    {
        return $this->hasMany('Question', 'category_id');
    }

    public function services()
    {
        return $this->hasMany('Service', 'category_id');
    }

}